import asyncio
from web3 import Web3
import config
from mempool_listener import MempoolListener
from strategy import SandwichStrategy
from transaction_builder import TransactionBuilder

def main():
    print("Starting MEV Sandwich Bot Framework...")
    w3 = Web3(Web3.HTTPProvider(config.ETH_RPC_URL))
    if not w3.is_connected():
        raise ConnectionError("Could not connect to Ethereum RPC")
    
    strategy = SandwichStrategy(config.TARGET_DEX_ROUTER)
    builder = TransactionBuilder(w3, config.PRIVATE_KEY)
    listener = MempoolListener(config.ETH_WSS_URL, config.ETH_RPC_URL, strategy)
    
    print("Listening to mempool for opportunities...")
    asyncio.run(listener.listen())

if __name__ == "__main__":
    main()