import asyncio
import json
import websockets
from web3 import Web3

class MempoolListener:
    def __init__(self, w3_wss_url, w3_rpc_url, strategy_handler):
        self.wss_url = w3_wss_url
        self.w3 = Web3(Web3.HTTPProvider(w3_rpc_url))
        self.strategy = strategy_handler

    async def listen(self):
        async with websockets.connect(self.wss_url) as ws:
            await ws.send(json.dumps({
                "id": 1, "method": "eth_subscribe", "params": ["newPendingTransactions"]
            }))
            
            while True:
                message = await ws.recv()
                tx_hash = json.loads(message)['params']['result']
                try:
                    tx = self.w3.eth.get_transaction(tx_hash)
                    opportunity = self.strategy.find_sandwich_opportunity(tx)
                    if opportunity and opportunity["is_opportunity"]:
                        # Trigger transaction builder and Flashbots sender
                        print("Actionable opportunity found. Executing...")
                except Exception:
                    continue