from web3 import Web3

class TransactionBuilder:
    def __init__(self, w3, private_key):
        self.w3 = w3
        self.private_key = private_key
        self.account = self.w3.eth.account.from_key(private_key)

    def create_swap_tx(self, router_address, path, amount_in, amount_out_min, nonce):
        router_contract = self.w3.eth.contract(address=router_address, abi=self.get_uniswap_abi())
        tx = router_contract.functions.swapExactTokensForTokens(
            amount_in,
            amount_out_min,
            path,
            self.account.address,
            (self.w3.eth.get_block('latest')['timestamp'] + 300)
        ).build_transaction({
            'from': self.account.address,
            'nonce': nonce,
            'gas': 300000,
            'maxFeePerGas': self.w3.to_wei('50', 'gwei'),
            'maxPriorityFeePerGas': self.w3.to_wei('2', 'gwei')
        })
        return self.w3.eth.account.sign_transaction(tx, self.private_key)
    
    def get_uniswap_abi(self):
        # In a real app, load this from a file
        return [{"inputs":[{"internalType":"uint256","name":"amountIn","type":"uint256"},{"internalType":"uint256","name":"amountOutMin","type":"uint256"},{"internalType":"address[]","name":"path","type":"address[]"},{"internalType":"address","name":"to","type":"address"},{"internalType":"uint256","name":"deadline","type":"uint256"}],"name":"swapExactTokensForTokens","outputs":[{"internalType":"uint256[]","name":"amounts","type":"uint256[]"}],"stateMutability":"nonpayable","type":"function"}]